#! /bin/bash
cd "$(dirname "$0")"

if [ `whoami` != "root" ]; then
 echo "Please run this script as root."
 exit
fi

checkForScript()
{
 if [ ! -f "$1" ]; then
  msg="Error occured, $1 script not found in this directory!"
  echo "$msg"
  if [ -f "log" ]; then
   ./log script.errors "$msg"
  else
   echo [$(date)]: "$msg" >> script.errors
  fi
  exit
 fi
}

checkForScript "log"
checkForScript "world.name"
checkForScript "pid"
checkForScript "stop.command"
checkForScript "run_nohup.command"

world_name=`./world.name`
archive_name=`./world.name archive`

if [ ! -d "$world_name" ]; then
 msg="Unable to create $archive_name because the $world_name directory does not exist!"
 echo "$msg"
 ./log script.errors "$msg"
 exit
fi

pid=$(./pid)

./stop.command "shutdown for world backup"

if [ "$(./pid)" != "" ]; then
 msg="Unable to create $archive_name because server could not be stopped!"
 echo "$msg"
 ./log script.errors "$msg"
 exit
fi

echo "Creating backup of world folder..."
temp_archive_name=$archive_name+".temp"
tar cvzf $temp_archive_name $world_name
mv -f $temp_archive_name $archive_name

if [ -f "$archive_name" ]; then
 echo "Backup created as $archive_name"
else
 msg="Error occured while trying to create $archive_name! Backup failed!"
 echo "$msg"
 ./log script.errors "$msg"
fi

if [ -f *.map ]; then
 printf "Archiving world maps..."
 temp_archive_name="world-maps.tar.gz.temp"
 tar czf "$temp_archive_name" *.map
 mv -f "$temp_archive_name" world-maps.tar.gz
 printf "done\n"
fi

if [ "$1" == "-u" ]; then
 #checkForScript "upload.command"
 ./upload.command
fi

if [ "$pid" != "" ]; then
 ./run_nohup.command
fi
