#! /bin/bash
cd "$(dirname "$0")"

if [ `whoami` != "root" ]; then
 echo "Please run this script as root."
 exit
fi

checkForScript()
{
 if [ ! -f "$1" ]; then
  msg="Error occured, $1 script not found in this directory!"
  echo "$msg"
  if [ -f "log" ]; then
   ./log script.errors "$msg"
  else
   echo [$(date)]: "$msg" >> script.errors
  fi
  exit
 fi
}

checkForScript "log"
checkForScript "pid"

#Check for updated jar file
jar_name="1.6.4-MITE-HDS.jar"
if [ -f "$jar_name".new ]; then
 echo Updating "$jar_name"
 mv -f "$jar_name".new "$jar_name"
fi

pid=$(./pid)
if [ "$pid" != "" ]; then
 echo 1.6.4-MITE server already running! Process ID is "$pid"
 exit
fi

if [ ! -f "$jar_name" ]; then
 echo Could not find "$jar_name"!
 exit
fi

mem_allocation_megabytes=2048

printf "Starting 1.6.4-MITE server in background..."
nohup java -Xmx"$mem_allocation_megabytes"M -Xms"$mem_allocation_megabytes"M -jar "$jar_name" nogui > /dev/null 2>&1 &
sleep 2

if [ "$(./pid)" == "" ]; then
 printf "failure\nThe server did not start!\n"
else
 printf "done\nServer started with $mem_allocation_megabytes MB of allocated memory.\n"
fi
