#! /bin/bash
cd "$(dirname "$0")"

if [ `whoami` != "root" ]; then
 echo "Please run this script as root."
 exit
fi

checkForScript()
{
 if [ ! -f "$1" ]; then
  msg="Error occured, $1 script not found in this directory!"
  echo "$msg"
  if [ -f "log" ]; then
   ./log script.errors "$msg"
  else
   echo [$(date)]: "$msg" >> script.errors
  fi
  exit
 fi
}

waitForShutdown()
{
 i=0
 while [ "$(./pid)" != "" ]
 do
  sleep 1
  (( i++ ))
  if [ $i == $1 ]; then break; fi
 done
}

trySignalFile()
{
 printf "Stopping 1.6.4-MITE server, please wait..."
 echo "$1" > signal.txt
 waitForShutdown $2
}

tryKillSignal()
{
 printf "\nProcess still running! Trying shutdown via SIGTERM..."
 kill $1
 waitForShutdown $2
 if [ "$(./pid)" == "" ]; then
  printf "done\n"
 else
  printf "\nCould not stop server!\n"
 fi
}

checkForScript "log"
checkForScript "pid"

pid=$(./pid)
if [ "$pid" == "" ]; then exit; fi

if [ "$1" == "shutdown for world backup" ]; then
 file_signal="$1"
 wait_for_file_signal=40
elif [ "$1" == "shutdown for update" ]; then
 file_signal="$1"
 wait_for_file_signal=40
elif [ "$1" == "shutdown immediately" ]; then
 file_signal="$1"
 wait_for_file_signal=2
else
 file_signal="shutdown"
 wait_for_file_signal=40
fi

trySignalFile "$file_signal" $wait_for_file_signal
pid=$(./pid)
if [ "$pid" == "" ]; then
 printf "done\n"
else
 tryKillSignal $pid 5
fi

#if [ -f "signal.txt" ]; then rm -f "signal.txt"; fi
