#! /bin/bash
cd "$(dirname "$0")"

if [ `whoami` != "root" ]; then
 echo "Please run this script as root."
 exit
fi

checkForScript()
{
 if [ ! -f "$1" ]; then
  msg="Error occured, $1 script not found in this directory!"
  echo "$msg"
  if [ -f "log" ]; then
   ./log script.errors "$msg"
  else
   echo [$(date)]: "$msg" >> script.errors
  fi
  exit
 fi
}

checkForScript "log"
checkForScript "pid"
checkForScript "stop.command"
checkForScript "run_nohup.command"

jar_name="1.6.4-MITE-HDS.jar"
update_jar_name="$jar_name.new"

if [ ! -f "$update_jar_name" ]; then
 echo "$update_jar_name not found."
 exit
fi

pid=$(./pid)

./stop.command "shutdown for update"

if [ "$(./pid)" != "" ]; then
 msg="Unable to update $jar_name because server could not be stopped!"
 echo "$msg"
 ./log script.errors "$msg"
 exit
fi

printf "Applying update to $jar_name..."

mv -f $update_jar_name $jar_name

if [ -f "$update_jar_name" ]; then
 printf "failed\nCould not overwrite $jar_name!\n"
 ./log script.errors "Update failed. Unable to overwrite $jar_name"
else
 printf "done\n"
fi

if [ "$pid" != "" ]; then
 ./run_nohup.command
fi
