#! /bin/bash
cd "$(dirname "$0")"

# In order for this script to run you will need to specify the following four values
# Also note that the ftp user you specify must have write access to the upload location

server="your-ftp-server-domain-or-ip-address"
directory="your-upload-directory-on-ftp-server-trailing-slash-not-needed"
username="your-ftp-account-username"
password="your-ftp-account-password"

checkForScript()
{
 if [ ! -f "$1" ]; then
  msg="Error occured, $1 script not found in this directory!"
  echo "$msg"
  if [ -f "log" ]; then
   ./log script.errors "$msg"
  else
   echo [$(date)]: "$msg" >> script.errors
  fi
  exit
 fi
}

if [ "$1" == "" ]; then
 checkForScript "world.name"

 world_name=`./world.name`
 filename=`./world.name archive`

 printf "Uploading $filename"

 if [ ! -f "$filename" ]; then
  printf "...failed\nFile not found!\n"
  exit
 fi

 filenames="$filename"

 filename="server.properties"
 if [ -f "$filename" ]; then
  filenames="$filenames $filename"
  printf ", $filename"
 fi

 filename="white-list.txt"
 if [ -f "$filename" ]; then
  filenames="$filenames $filename"
  printf ", $filename"
 fi

 filename="world-maps.tar.gz"
 if [ -f "$filename" ]; then
  filenames="$filenames $filename"
  printf ", $filename"
 fi

 printf "..."

 ftp -i -n $server <<End-Of-Session > /dev/null 2>&1
 user $username $password
 binary
 cd $directory
 mkdir $world_name
 cd $world_name
 mput $filenames
 bye
End-Of-Session

 printf "done\n"
else
 filename="$1"

 printf "Uploading $filename..."

 if [ ! -f "$filename" ]; then
  printf "failed\nFile not found!\n"
  exit
 fi

 ftp -n $server <<End-Of-Session
 user $username $password
 binary
 cd $directory
 put $filename
 bye
End-Of-Session

 printf "done\n"
fi
